#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTest.VAL;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
using gov.va.med.vbecs.DAL.VAL;
using gov.va.med.vbecs.DAL.VAL.RPC;
#endregion


namespace gov.va.med.vbecs.VAL.UnitTests
{
	[TestFixture]
	public class VAL_ComponentClassUnitTest : BaseTest 
	{
		private string _rpcCallXmlResult;

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();

			VistALinkUnitTestHarness.RequireConnection();

			_rpcCallXmlResult = new ComponentClass().GetComponentClassList();
		}

		[TearDown]
		protected void TearDown()
		{
			VistALinkUnitTestHarness.ReleaseConnection(); 
		}

		[Test]
		public void GetComponentClassList_Pass()
		{
			Assert.IsNotNull( _rpcCallXmlResult );
			
			DataSet _ds = RpcFunctionUnitTestUtility_VAL.LoadXmlStringIntoDataSet( _rpcCallXmlResult );
			
			Assert.IsTrue( _ds.Tables[0].Rows.Count == 6 );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void GetComponentClassList_Fail() {}
	}
}
#endif
